require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Lightfooted"

-- Footsteps sound radius multiplier by level (lower is quieter).
-- Wiki table (L0..L10): 99, 90, 79, 71, 65, 59, 52, 45, 37, 30, 20
-- We map only 1..10 for in-game levels:
local _FOOTSTEP_RADIUS_BY_LVL = { 90, 79, 71, 65, 59, 52, 45, 37, 30, 20 }

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    local rad = _FOOTSTEP_RADIUS_BY_LVL[lvl]

    -- Header (parity with other skills)
    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    ctx.add(ST.getText("IGUI_DST_Lightfooted_val_FootstepRadius", tostring(rad or "-")))
    ctx.addSeparator()
    ctx.add(ST.getText("IGUI_DST_Lightfooted_info_StacksWithNimble"))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)